<?php
  class Joblist_model extends CI_Model {
    public function __construct()
      {
          $this->load->database();
      }
    public function getalljobpost()
{
    $deptId = $this->session->userdata('departmentId') ?? 0;
    $academicId = $this->session->userdata('acadamicyearId') ?? 0;
    $passingId = $this->session->userdata('passingYearId') ?? 0;
    $newold = $this->session->userdata('newold') ?? 0;

    // Ensure scalar values for FIND_IN_SET
    if (is_array($academicId)) {
        $academicId = $academicId[0];
    }
    if (is_array($passingId)) {
        $passingId = $passingId[0];
    }

    // -------------------------------------------
    // 1. STUDENT POSTS (postedBy IS NULL)
    // -------------------------------------------
    $this->db->select("jobpostId ,jobpostName,jobpost_master.mobileNo,jobpost_master.jobdescription,jobcategory,experiencelevel,salaryMin,salaryMax,location,qualification,skills,uploadfile, jobpost_master.status, jobpost_master.created_date, jobpost_master.skills, jobtype_master.jobtypeId,jobtype_master.jobtypeName, studentregistration_master.created_by, studentregistration_master.studentName, studentregistration_master.address, studentregistration_master.jobProfile,studentregistration_master.Id,jobpost_master.companylogo,jobpost_master.companyName,studentregistration_master.activejob,jobpost_master.postedBy");
    $this->db->from('jobpost_master');
    $this->db->join('jobtype_master', 'jobpost_master.jobtype = jobtype_master.jobtypeId');
    $this->db->join('studentregistration_master', 'studentregistration_master.Id = jobpost_master.created_by');
    $this->db->where('jobpost_master.status', 1);
    $this->db->where('jobpost_master.postedBy IS NULL', null, false);

    // Add filters to student posts
    if ($deptId != 0) {
        $this->db->group_start();
        $this->db->where("FIND_IN_SET($deptId, jobpost_master.departmentId) >", 0);
        $this->db->group_end();
    }

    if ($newold == 1 && $academicId != 0) {
        $this->db->group_start();
        $this->db->where("FIND_IN_SET($academicId, jobpost_master.AcadamicyearId) >", 0);
        $this->db->or_where('jobpost_master.AcadamicyearId', 0);
        $this->db->group_end();
    }

    if ($newold == 2 && $passingId != 0) {
        $this->db->group_start();
            $this->db->group_start();
                $this->db->where('jobpost_master.NewoldFlag !=', 0);
                $this->db->where("FIND_IN_SET($passingId, jobpost_master.passingyearId) >", 0);
            $this->db->group_end();
            $this->db->or_where('jobpost_master.NewoldFlag', 0);
        $this->db->group_end();
    }

    $this->db->group_start();
    $this->db->where('jobpost_master.NewoldFlag', $newold);
    $this->db->or_where('jobpost_master.NewoldFlag', 0);
    $this->db->group_end();

    $query1 = $this->db->get_compiled_select();

    // -------------------------------------------
    // 2. DEPARTMENT POSTS (postedBy > 0)
    // -------------------------------------------
    $this->db->select("jobpostId ,jobpostName,jobpost_master.mobileNo,jobpost_master.jobdescription,jobcategory,experiencelevel,salaryMin,salaryMax,location,qualification,skills,uploadfile, jobpost_master.status, jobpost_master.created_date, jobpost_master.skills, jobtype_master.jobtypeId,jobtype_master.jobtypeName, department_master.created_by, department_master.personname as studentName, 0 as address, 0 as jobProfile, 0 as Id, jobpost_master.companylogo, jobpost_master.companyName, 0 as activejob, jobpost_master.postedBy");
    $this->db->from('jobpost_master');
    $this->db->join('jobtype_master', 'jobpost_master.jobtype = jobtype_master.jobtypeId');
    $this->db->join('department_master', 'department_master.departmentId = jobpost_master.postedBy');
    $this->db->where('jobpost_master.status', 1);
    $this->db->where('jobpost_master.postedBy >', 0);

    // Add filters to department posts
    if ($deptId != 0) {
        $this->db->group_start();
        $this->db->where("FIND_IN_SET($deptId, jobpost_master.departmentId) >", 0);
        $this->db->group_end();
    }

    if ($newold == 1 && $academicId != 0) {
        $this->db->group_start();
        $this->db->where("FIND_IN_SET($academicId, jobpost_master.AcadamicyearId) >", 0);
        $this->db->or_where('jobpost_master.AcadamicyearId', 0);
        $this->db->group_end();
    }

    if ($newold == 2 && $passingId != 0) {
        $this->db->group_start();
            $this->db->group_start();
                $this->db->where('jobpost_master.NewoldFlag !=', 0);
                $this->db->where("FIND_IN_SET($passingId, jobpost_master.passingyearId) >", 0);
            $this->db->group_end();
            $this->db->or_where('jobpost_master.NewoldFlag', 0);
        $this->db->group_end();
    }

    $this->db->group_start();
    $this->db->where('jobpost_master.NewoldFlag', $newold);
    $this->db->or_where('NewoldFlag', 0);
    $this->db->group_end();

    $query2 = $this->db->get_compiled_select();

    // -------------------------------------------
    // Final Combined Query with UNION
    // -------------------------------------------
    $finalQuery = "($query1) UNION ($query2) ORDER BY jobpostId DESC";

    $query = $this->db->query($finalQuery);
    return $query->result();
}
   

     public function getallfirm()
     {      
      $Id = $this->session->userdata('Id');
        $this->db->select('jobpostId ,jobpostName,jobpost_master.mobileNo,jobdescription,jobcategory,experiencelevel,salaryMin,salaryMax,location,qualification,skills,uploadfile, jobpost_master.status, jobpost_master.created_date, GROUP_CONCAT(DISTINCT keyskill_master.keyName) AS keyName, jobtype_master.jobtypeId,jobtype_master.jobtypeName, businessregistration_master.firmName, businessregistration_master.Id, businessregistration_master.officeAddress,businessregistration_master.profile');
        $this->db->from('jobpost_master');
        $this->db->join('jobtype_master', 'jobpost_master.jobtype= jobtype_master.jobtypeId');
        $this->db->join('businessregistration_master', 'businessregistration_master.Id = jobpost_master.created_by');
        $this->db->join('keyskill_master', 'FIND_IN_SET(keyskill_master.keyId, jobpost_master.skills) > 0');
        $this->db->where('jobpost_master.status',1);
        $this->db->group_by('jobpost_master.jobpostId'); 
        $this->db->where('jobpost_master.created_by',$Id);
        $this->db->order_by('jobpost_master.jobpostId','desc');

        $query = $this->db->get();  
        return $query->result();
        return $this->db->last_query();
     }   


 
    public function getalljobpostbtid($jobId)
    {      
     $this->db->select('jobpostId ,jobpostName,applyurl,jobpost_master.mobileNo,jobpost_master.jobdescription,jobcategory,experiencelevel,salaryMin,salaryMax,location,qualification,skills,uploadfile, jobpost_master.status, jobpost_master.created_date, jobpost_master.skills,experience_master.experienceId ,experience_master.experienceName,jobtype_master.jobtypeId,jobtype_master.jobtypeName, studentregistration_master.studentName, studentregistration_master.Id, studentregistration_master.address, studentregistration_master.jobProfile,companylogo,jobpost_master.companyName');
       $this->db->from('jobpost_master');
       $this->db->join('jobtype_master', 'jobpost_master.jobtype= jobtype_master.jobtypeId');
       // $this->db->join('keyskill_master', 'FIND_IN_SET(keyskill_master.keyId, jobpost_master.skills) > 0');
       $this->db->join('studentregistration_master', 'studentregistration_master.Id = jobpost_master.created_by');
       $this->db->join('experience_master', 'jobpost_master.experiencelevel= experience_master.experienceId');
      
       
       $this->db->where('jobpost_master.jobpostId',$jobId);
       $query = $this->db->get();
       return $query->result();
            
    }  
}